import java.io.File;
import java.io.FileNotFoundException;
import java.util.Random;
import java.util.Scanner;

public class Pyramid {

    /** pyramidData berisi informasi Person di poin tertentu */
    private Person pyramidData[][];

    /** level / tingkat dari piramida manusia yang diinginkan */
    private static int level = 0;

    public static void main(String args[]) {

        if (args.length == 0) {
            System.err.println("Anda harus memberikan argument");
            return;
        }

        // objek scanner ini digunakan untuk membaca input dari file
        Scanner input = null;

        // Umumnya, anda harus membuat objek Pyramid terlebih dahulu
        Pyramid pyramid = new Pyramid();

        try {
            level = Integer.parseInt(args[0]);

            // Anda dapat memanggil fungsi ini untuk 'mengisi' piramid Anda
            // Jangan lupa untuk menginisiasi array terlebih dahulu
            // pyramid.fillData(level);

        } catch (NumberFormatException nfe) {

            // kode untuk membaca file
            try {
                input = new Scanner(new File(args[0]));
            } catch (FileNotFoundException e) {
                System.out.println("Berkas "+args[0]+" tidak ditemukan.");
                return;
            }

            // olah objek scanner agar memberikan format yang kita inginkan
            // level = Integer.parseInt(input.nextLine());
            // dst..

        }

        // Anda diminta untuk melihat performa fungsi rekursif anda

        // cek waktu awal sebelum mencari semua beban
        long startTime = System.currentTimeMillis();

        // lakukan penghitungan computeLoad untuk semua index disini
        // sambil cetak ke layar
        for (int i = 0; i < level; i++) {
            for (int j = 0; j <= pyramid.pyramidData[i].length; j++) {
                System.out.printf("%.3f ",pyramid.computeLoad(i,j));
            }
            System.out.println();
        }

        // ambil selisih waktu
        long estimatedTime = System.currentTimeMillis() - startTime;
        System.out.println("\nProgram selesai : "+estimatedTime+" ms");

      }

    private double computeLoad(int row, int col) {
        // implementasi fungsi ini secara rekursif
        return 0.0;
    }

    /** fungsi ini bertujuan untuk mengisi data pyramidData dengan nilai random */
    private void fillData(int level) {
        Random r = new Random();
        String nama = "";
        int berat = 0;
        int count = 0;

        for (int i = 0; i < level; i++) {
            for (int j = 0; j <= this.pyramidData[i].length-1; j++) {
                nama = Pyramid.generateName(count++);
                berat = r.nextInt(50) + 40;

                // silakan dilanjutkan
            }
        }
    }

    /** Fungsi ini berguna untuk mencetak piramid ke layar */
    private void print() {
        for(Person[] row : this.pyramidData) {
            for (Person p : row) {
                System.out.printf(p + " ");
            }
            System.out.println();
        }
    }

    /** Fungsi generateName digunakan untuk men-generate alfabet sesuai dengan
        urutannya (int)
    */
    private static String generateName(int i) {
        return i < 0 ? "" : generateName((i / 26) - 1) + (char)(65 + i % 26);
    }
}
